this.name        = "ups_docs"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Docs missions of UPS Courier"; 
this.version     = "1.3.2"; 


this.startUp = function()
{
    if (oolite.compareVersion("1.70") > 0)
    {
        // Oolite version is older than 1.70.
        LogWithClass("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Parcel missions are disabled.")
        delete this.missionScreenEnded
        delete this.shipExitedWitchspace
        delete this.shipDockedWithStation
        delete this.shipLaunchedFromStation
    }
}

this.choiceWarning = false

this.shipDockedWithStation = function()
{
        this.ups_missionoffers()
}

this.missionScreen=function(messageKey, backGround, choiceKey)
{
        mission.showShipModel();mission.setMusic()
	mission.setBackgroundImage(backGround);
	mission.showMissionScreen();
	mission.addMessageTextKey(messageKey);
        if (choiceKey != null) mission.setChoicesKey(choiceKey)
}

this.ups_missionoffers = function()
{
    if (player.dockedStation.isMainStation && !missionVariables.offering && guiScreen != "GUI_SCREEN_MISSION")
    {
        if(!missionVariables.ups_docs)
        {
            missionVariables.ups_docs = "NO" 
            missionVariables.ups_dcount = 0 
            missionVariables.ups_planet = 0 
            missionVariables.ups_cplanet = 0 
            missionVariables.ups_difference = 0 
            missionVariables.ups_parcel = "NO" 
            missionVariables.ups_pcount = 0 
            missionVariables.ups_pplanet = 0 
            missionVariables.ups_container = "NO"
            missionVariables.ups_ccount = 0
            missionVariables.ups_c1count = 0
            missionVariables.ups_c2count = 0 
            missionVariables.ups_ecount = 0 
            missionVariables.ups_ccount = 0 
            missionVariables.ups_cplanet = 0
            missionVariables.ups_galcop_punishment = 0
            missionVariables.ups_galaxy = system.galaxy
        }
        if(missionVariables.ups_docs == "YES")
        {
            if(player.bounty < 3 && system.government == 6 && !mission.choice)
            {
                missionVariables.ups_docs_appearance = ExpandDescription("[ups_numbers]") + " " + ExpandDescription("[ups_condition]") + " " +  ExpandDescription("[%I]") 
                if (missionVariables.ups_dcount == 0){this.missionScreen("ups_docs_1st_offer", "UPS.png", "ups_docs_accepted_yesno")}
                else {this.missionScreen("ups_docs_offer", "UPS.png", "ups_docs_accepted_yesno")}
                missionVariables.offering = "UPS_DOCS"
            }
        }
        if(missionVariables.ups_docs == "SMALL_DELIVERY" && system.government == 6)
        {
            if(missionVariables.ups_dplanet ==  system.ID)
            {
                missionVariables.ups_docs = "ACCEPTED"
                this.missionScreen("ups_back_at_home", "UPS.png", null)
            }
            else
            {
                missionVariables.ups_docs = "NOT_NOW"
                player.credits += 100
                if(missionVariables.ups_dcount == 0)
                {mission.setBackgroundImage("UPS.png");this.missionScreen("ups_docs_1st_unloading", "UPS.png", null) }
                else{this.missionScreen("ups_docs_unloading", null, null)}
                mission.setInstructionsKey()
                missionVariables.ups_dcount++
                missionVariables.ups_docs_appearance = null
                player.call("increaseContractReputation")
            }
        }
        if(missionVariables.ups_docs == "LOGGING")
        {
            if(system.government == 6 && !mission.choice && missionVariables.ups_dplanet != system.ID)
            {
                    this.missionScreen("ups_docs_offer2", "UPS.png", "ups_docs_accepted_yesno")
                    missionVariables.offering = "UPS_DOCS2"
            }
        }
        if(missionVariables.ups_docs == "SPECIAL_DELIVERY")
        {
            if(missionVariables.ups_dplanet == system.ID && system.government == 6 && !missionVariables.ups_docbriefing)
            {
                    this.missionScreen("ups_docs_unloading2a", "UPS.png", null)
                    mission.setInstructionsKey("ups_docs_small3")
                    missionVariables.ups_docbriefing = "YES"
            }
        }
        if(missionVariables.ups_docs == "ASTEROID_OFFER")
        {
            if(system.countShipsWithRole("asteroid") < 15 && !mission.choice)
            {
                    this.missionScreen("ups_docs_asteroid1", "UPS.png", "ups_docs_asteroid_yesno")
                    missionVariables.offering = "UPS_DOCS_ASTEROID"
            }
        }
    }
    if ((player.dockedStation.shipDescription == "Sun Research Station Alpha" || player.dockedStation.shipDescription == "Sun Research Station Beta" || player.dockedStation.shipDescription == "Sun Research Station Delta" || player.dockedStation.shipDescription == "Sun Research Station Omega"))
    {
        if(missionVariables.ups_docs == "SPECIAL_DELIVERY" && !missionVariables.offering && guiScreen != "GUI_SCREEN_MISSION")
        {
            missionVariables.ups_docs = "NOT_NOW", 
            player.credits += 250 
            this.missionScreen("ups_docs_unloading2", null , null)
            mission.setInstructionsKey()
            missionVariables.ups_dcount++
//          mission.unmarkSystem(missionVariables.ups_dplanet)  // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_dlanet)
            player.call("increaseContractReputation")
            missionVariables.ups_dplanetname = null
            missionVariables.ups_docbriefing = null
            if(player.dockedStation.shipDescription == "Sun Research Station Alpha" && !missionVariables.ups_sun )
            {
                missionVariables.ups_sun = "NOT_NOW"
                missionVariables.ups_sunbase = "YES"
                missionVariables.ups_sunvisits = 0
                missionVariables.ups_splanetname = missionVariables.ups_dplanet
            }
        }
    }
    if(this.choiceWarning) this.missionScreen("ups_warning", "UPS.png" , null)
}

this.missionScreenEnded = function()
{
//LogWithClass("script."+this.name, "The screen on missionscreen ending is: " + guiScreen)
    if (missionVariables.offering == "UPS_DOCS")
    {
        if(mission.choice == "YESDoc")
        {
            mission.clearMissionScreen() 
            mission.resetMissionChoice()
            mission.setInstructionsKey("ups_docs_small") 
            missionVariables.ups_docs = "ACCEPTED" 
            missionVariables.offering = null
            missionVariables.ups_dplanet = system.ID 
        }
        else
        {
            if (mission.choice == "NODoc")
            {
                mission.clearMissionScreen() 
                mission.resetMissionChoice()
                missionVariables.ups_docs = "NOT_NOW" 
                missionVariables.offering = null
                missionVariables.ups_docs_appearance = null
                if (Math.random() < 0.3){player.call("decreaseContractReputation")}
            }
        }
    }
    if (missionVariables.offering == "UPS_DOCS2")
    {
        if(mission.choice == "YESDoc")
        {
            mission.clearMissionScreen() 
            mission.resetMissionChoice()
            mission.setInstructionsKey("ups_docs_small2") 
            missionVariables.ups_docs = "SPECIAL_DELIVERY" 
            missionVariables.offering = null
            mission.markSystem(missionVariables.ups_dplanet) 
        }
        else
        {
            if (mission.choice == "NODoc")
            {
                mission.clearMissionScreen() 
                mission.resetMissionChoice()
                missionVariables.ups_docs = "NOT_NOW" 
                missionVariables.offering = null
            }
        }
    }
    if (missionVariables.offering == "UPS_DOCS_ASTEROID")
    {
        if(mission.choice == "YESDoc")
        {
            missionVariables.offering == "UPS_DOCS_ASTEROID2"
            mission.resetMissionChoice()
            this.missionScreen("ups_docs_asteroid2", null, null)
            mission.setInstructionsKey("ups_docs_asteroid_short") 
            missionVariables.ups_docs = "ASTEROID"
            missionVariables.ups_asteroid_count = 16
            missionVariables.offering = null
        }
        else
        {
            if (mission.choice == "NODoc")
            {
                mission.clearMissionScreen() 
                mission.resetMissionChoice()
                missionVariables.ups_docs = "NOT_NOW" 
                missionVariables.offering = null
            }
        }
    }
    this.ups_missionoffers
}

this.shipExitedWitchspace = function()
{
    this.setUpShips_ups_docs();
    if(missionVariables.ups_docs == "NOT_NOW" && Math.random() < 0.1){missionVariables.ups_docs = "NO"}
    if(missionVariables.ups_docs == "ACCEPTED")
    {missionVariables.ups_docs = "SMALL_DELIVERY"; system.legacy_addSystemShips("trader", 2, Math.random())}
    if(missionVariables.ups_docs == "NO")
    {
        if(missionVariables.ups_docs == "NO" && Math.random() < 0.2 && system.government == 6)
        {missionVariables.ups_docs == "YES"}
        if(missionVariables.ups_docs == "NO" && Math.random() < 0.05 && system.government == 6 && missionVariables.ups_dcount > 5 && !system.goneNova)
        {
            missionVariables.ups_docs == "LOGGING"; 
            missionVariables.ups_dplanet = system.ID; 
            missionVariables.ups_dplanetname = ExpandDescription("[%H]")
        }
        if(missionVariables.ups_docs == "NO" && Math.random() < 0.04 && missionVariables.ups_dcount > 20 && system.countShipsWithRole("asteroid") < 13)
        {missionVariables.ups_docs == "ASTEROID_OFFER"}
    }
    else
    {
        if (missionVariables.ups_docs == "ASTEROID")
        {
            missionVariables.ups_docs == "NOT_NOW"
            missionVariables.ups_asteroid_count = null
            mission.setInstructionsKey() 
        }
        if (missionVariables.ups_docs == "SMALL_DELIVERY" && system.ID > -1)
        {system.legacy_addSystemShips("trader", 1, Math.random()); system.legacy_addSystemShips("trader", 1, Math.random())}
        if (missionVariables.ups_docs == "SPECIAL_DELIVERY" && system.ID > -1 && system.government < 2)
        {
            system.legacy_addSystemShips("ups_pirate", 10, 1);
            system.legacy_addSystemShips("ups_pirate", 10, 0.15);
            system.legacy_addSystemShips("hunter", 3, Math.random())
            if(missionVariables.ups_dcount > 15)
            {system.legacy_addSystemShips("ups_pirate_leader", 1, 0.35);system.legacy_addSystemShips("ups_pirate_leader", 2, 0.85)}
        }
    }
    if(missionVariables.ups_docsreset == "YES")
    {
        if(missionVariables.ups_docs == "LOGGING" || missionVariables.ups_docs == "SPECIAL_DELIVERY")
        {
            missionVariables.ups_dplanetname = null
            missionVariables.ups_docsbriefing = null
            missionVariables.ups_docs = "NOT_NOW"
            mission.setInstructionsKey()
//          mission.unmarkSystem(missionVariables.ups_dplanet) // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_dplanet)
            missionVariables.ups_dplanet = null
            missionVariables.ups_docs_appearance = null
        }
        missionVariables.ups_docsreset = null
    }
}

this.setUpShips_ups_docs = function()
{
    if(missionVariables.ups_docs == "SPECIAL_DELIVERY" && missionVariables.ups_dplanet == system.ID)
    {
        let addSunskimmers = true
        if(!missionVariables.ups_sun)
        {
            if(system.countShipsWithRole("ups_dependance") == 0)
            {system.legacy_addShipsAt("ups_dependance", 1, "sps", 0, 0, 2.6); addSunskimmers = false}
        }
        else
        {
            if(system.countShipsWithRole("ups_dependance2") == 0)
            {system.legacy_addShipsAt("ups_dependance2", 1, "sps", 0, 0, 2.6); addSunskimmers = false}
        }
        if(addSunskimmers)
        {
            system.legacy_addShipsAt("ups-sunskim", 3, "sps", 0, 0, 2.6)
            system.legacy_addShipsAt("ups_shuttle", 8, "sps", 0, 0, 2.6)
            system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "spu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sun-police", 4, "spu", 0, 0, (Math.random()*0.8 + 0.1))
            system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, Math.random())
            system.legacy_addShipsAt("ups-sunskim", 1, "swu", 0, 0, Math.random())

        }
    }
}

this.shipLaunchedFromStation = function()
{
    this.setUpShips_ups_docs()
    missionVariables.offering = null
    if(mission.choice && mission.choice != "") {mission.setChoicesKey();this.choiceWarning = true}
    if(missionVariables.ups_docs == "ASTEROID")
    {
        if(system.countShipsWithRole("ups-miner") == 0 && missionVariables.ups_asteroid_count > 8)
        {
            missionVariables.ups_asteroids = 15
            system.legacy_addShipsAt("asteroid", 15, "pwu", 0, 0, -0.5)
            system.legacy_addShipsAt("asteroid", 15, "pwu", 0, 0, -0.7)
            system.legacy_addShipsAt("ups-miner", 2, "pwu", 0, 0, -0.6)
            system.legacy_addShipsAt("ups-miner", 5, "pwu", 0, 0, -0.8)
            system.legacy_addShipsAt("ups-miner", 5, "pwu", 0, 0, -1.0)
            missionVariables.ups_asteroids = null
        }
    }
    
}